VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Power Measurement (V1.2)"
   ClientHeight    =   4620
   ClientLeft      =   2385
   ClientTop       =   2355
   ClientWidth     =   8400
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4620
   ScaleWidth      =   8400
   Begin VB.CommandButton Command4 
      Caption         =   "Total Power (11b)"
      Height          =   495
      Left            =   5760
      TabIndex        =   6
      Top             =   960
      Width           =   1695
   End
   Begin VB.CommandButton Command3 
      Caption         =   "SEM (11b)"
      Height          =   495
      Left            =   3840
      TabIndex        =   5
      Top             =   960
      Width           =   1695
   End
   Begin VB.CommandButton Command2 
      Caption         =   "SEM (11a)"
      Height          =   495
      Left            =   1800
      TabIndex        =   4
      Top             =   960
      Width           =   1815
   End
   Begin VB.CommandButton Command1 
      Caption         =   "CH Power"
      Height          =   495
      Index           =   3
      Left            =   1080
      TabIndex        =   0
      Top             =   240
      Width           =   1515
   End
   Begin VB.CommandButton Command1 
      Caption         =   "S.E.M."
      Height          =   495
      Index           =   2
      Left            =   6480
      TabIndex        =   3
      Top             =   240
      Width           =   1515
   End
   Begin VB.CommandButton Command1 
      Caption         =   "ACP"
      Height          =   495
      Index           =   1
      Left            =   4680
      TabIndex        =   2
      Top             =   240
      Width           =   1515
   End
   Begin VB.TextBox txtRslt 
      BeginProperty Font 
         Name            =   "lr SVbN"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2235
      Left            =   360
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   7
      Top             =   1800
      Width           =   7635
   End
   Begin VB.CommandButton Command1 
      Caption         =   "OBW"
      Height          =   495
      Index           =   0
      Left            =   2880
      TabIndex        =   1
      Top             =   240
      Width           =   1515
   End
   Begin VB.Label Label2 
      Caption         =   "WLAN:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   960
      TabIndex        =   9
      Top             =   1080
      Width           =   615
   End
   Begin VB.Label Label1 
      Caption         =   "3GPP:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000D&
      Height          =   255
      Left            =   360
      TabIndex        =   8
      Top             =   360
      Width           =   615
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const MFREQ As Double = 2000000000# 'LAg
Const OBW_REF As Double = 0#        'OBW Reference level
Const ACP_REF As Double = 0#        'ACP Reference level
Const SEM_REF As Double = 0#        'SEM Reference level
Const POW_REF As Double = 0#        'POW Reference level

Sub MeasSEM(measF As Double, measRef As Double)
Dim dRslt() As String

Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec

txtRslt.SelText = vbCrLf & "SEM Measurement..." & vbCrLf

' 1. Parameter setting
ibwrt ud, "SI"
ibwrt ud, "CF " & Format(measF) & "HZ"    'Center frequency
'   ibwrt ud, "RO 20DB; RO ON"                 'Level Offset
ibwrt ud, "RL " & Format(measRef) & "DB"  'Reference level
ibwrt ud, "AL"                            'All Auto or RBW,VBW,SWP
ibwrt ud, "DETAA ON"                      'DET Auto
ibwrt ud, "SP 20MZ"
ibwrt ud, "SEMCBW 3.84MZ"
ibwrt ud, "SEMRFCALC CHN"                 'Power = CH_Power or Peak_Power (miss-pri :V1.2)
ibwrt ud, "SEMNQST OFF"

' 2. Set Mask(3GPP)
ibwrt ud, "SEMTDEL"
ibwrt ud, "SEMTIN 2.515MZ,2.715MZ, 30KZ, -14DB, -14DB, 0DB, 0DB,ABS"
ibwrt ud, "SEMTIN 2.715MZ,3.515MZ, 30KZ, -14DB, -26DB, 0DB, 0DB,ABS"
ibwrt ud, "SEMTIN 3.515MZ,4.0MZ, 30KZ, -26DB, -26DB, 0DB, 0DB,ABS"
ibwrt ud, "SEMTIN 4.0MZ,8.0MZ, 1MZ, -13DB, -13DB, 0DB, 0DB,ABS"

' 3. Measure SEM
Dim buf As String * 200
Dim i As Integer
ibwrt ud, "SEMON"
ibwrt ud, "TS"    ' Take sweep
ibwrt ud, "SEM?"

txtRslt.SelText = " START F      STOP F       FREQ.      ABS LEV   REL LEV" & vbCrLf
For i = 0 To 7
    buf = ""
    ibrd ud, buf
    dRslt = Split(buf, ",")
    txtRslt.SelText = Format(dRslt(1) / 1000000#, "#0.00") & "MHz---" & Format(dRslt(2) / 1000000#, "#0.00") & "MHz, " _
    & Format(dRslt(3) / 1000000#, "#0.00") & "MHz, " & Format(dRslt(4), "#0.00") & "dBm, " & Format(dRslt(5), "#0.00") & "dB" _
    & vbCrLf
Next i
Call ibwrt(ud, "SEMON OFF")
Call ibwrt(ud, "CONTS")             'Sweep continue
'  Call ibwrt(ud, "RO OFF")         'Offset level Off

Call ibonl(ud, 0)                   'GPIB device 
Call ibonl(0, 0)                    'GPIB board 

End Sub

Sub MeasObw(measF As Double, measRef As Double)
Dim sBuff As String * 50
Dim dRslt() As String

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "OBW Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "SP 10e6HZ")                     'Span 10MHz
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, "RB 30e3HZ; VB 30e3HZ")          'RBW 30kHz, VBW 30kHz
    Call ibwrt(ud, "AS")                            'Sweep Time Auto
    Call ibwrt(ud, "DET POS")                       'Detector mode (POSI)
                                                       'Auto --> Average DET
    Call ibwrt(ud, "OBWPER 99")                     'OBW 99%

    Call ibwrt(ud, "OBWON")                         'Meas OBW
    If 0 Then                                   'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                        'Averageꍇ
        Call ibwrt(ud, "AGSGL")                         'AVG single
        Call ibwrt(ud, "AG 10")                         'AVG 10 times
        Call ibwrt(ud, "AGR")                           'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitAvgEnd                                      'Wait AVG end
    End If
    
    Call ibwrt(ud, "OBW?")                          'GET OBW data
    Call ibrd(ud, sBuff)                            'GET OBW data
    
    Call ibwrt(ud, "OBWON OFF")
    Call ibwrt(ud, "AGS")                           'AVG off
    
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = "OBW = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz" & vbCrLf
    txtRslt.SelText = "OBW CF = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf

    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 

End Sub

Sub MeasAcp(measF As Double, measRef As Double)
Dim rdBuf(2) As String * 100, rdRef As String * 100
Dim dRslt5() As String, dRslt10() As String
    
    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "ACP Measurement..." & vbCrLf
    
    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "SP 25e6HZ")                     'Span 25MHz
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, "RB 30e3HZ; VB 30e3HZ")          'RBW 30kHz, VBW 30kHz
    Call ibwrt(ud, "AS")                            'Sweep Time Auto
    Call ibwrt(ud, "ACPSCR CARR")                   'ACP Carrier power
    Call ibwrt(ud, "CARRBS 3.84MZ")                 'ACP Carrier bandwidth
    Call ibwrt(ud, "CSBSDEL")                       'ACP Clear table
    Call ibwrt(ud, "CSBSIN 5MZ,3.84MZ")             'ACP Channel spacing and bandwidth
    Call ibwrt(ud, "CSBSIN 10MZ,3.84MZ")            'ACP Channel spacing and bandwidth
    Call ibwrt(ud, "DETAA ON")                      'DET Auto
    ' Call ibwrt(ud, "DET SMP")                       'Detector mode (sample)
                                                      'Auto --> Average DET

    Call ibwrt(ud, "ACP")                           'Execute ACP measurement
    If 0 Then                                   'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                        'Averageꍇ
        Call ibwrt(ud, "AGSGL")                         'AVG single
        Call ibwrt(ud, "AG 10")                         'AVG 10 times
        Call ibwrt(ud, "AGR")                           'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitAvgEnd                                      'Wait AVG end
    End If
    
    Call ibwrt(ud, "ACP?")                          'Get ACP data
    Call ibrd(ud, rdBuf(0))                         'Get ACP data
    Call ibrd(ud, rdBuf(1))                         'Get ACP data
    Call ibrd(ud, rdBuf(2))                         'Get ACP data
    Call ibwrt(ud, "MO")                            'Markers OFF
    
    Call ibwrt(ud, "ACPREF?")                       'Get ACP carrier data
    Call ibrd(ud, rdRef)                            'Get ACP carrier data
    
    Call ibwrt(ud, "DETAA ON")                      'DetectorAUTOɖ߂
    Call ibwrt(ud, "AGS")                           'AVG off
    Call ibwrt(ud, "ACP OFF")
    
    'ʕ\
    dRslt5 = Split(rdBuf(1), ",")
    dRslt10 = Split(rdBuf(2), ",")
    
    txtRslt.SelText = "ACP ( -5M, +5M) = " & _
        Format(dRslt5(0) / 1000000#, "#0.00") & "MHz " & Format(dRslt5(1), "#0.00") & "dB : " & _
        Format(dRslt5(2) / 1000000#, "#0.00") & "MHz " & Format(dRslt5(3), "#0.00") & "dB" & vbCrLf
    txtRslt.SelText = "ACP (-10M,+10M) = " & _
        Format(dRslt10(0) / 1000000#, "#0.00") & "MHz " & Format(dRslt10(1), "#0.00") & "dB : " & _
        Format(dRslt10(2) / 1000000#, "#0.00") & "MHz " & Format(dRslt10(3), "#0.00") & "dB" & vbCrLf
    txtRslt.SelText = "ACP (Carr pow.) = " & Format(rdRef, "##0.00") & "dBm" & vbCrLf
    
    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 
    
End Sub

Sub MeasChPow(measF As Double, measRef As Double)
Dim sBuff As String * 50
Dim dRslt As String

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "CH Power Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "SP 10e6HZ")                     'Span 10MHz
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, "RB 300e3HZ VB 300e3HZ")         'RBW 300kHz, VBW 300kHz
    Call ibwrt(ud, "AS")                            'Sweep Time Auto
    ' Call ibwrt(ud, "SW 100MS")                      'Sweep time
    
    Call ibwrt(ud, "DETAA ON")                      'DET Auto
        
    Call ibwrt(ud, "WLX " & Format(measF) & "HZ")   'Ch Center
    Call ibwrt(ud, "WDX " & Format(3840000#) & "HZ") 'Ch Span
    Call ibwrt(ud, "PWCHON")                         'Ch Pow ON
    
    If 0 Then                                   'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                        'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWCHTM 10")                     'AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait AVG end
    End If
    
    Call ibwrt(ud, "PWCH?")                         'GET POW data
    Call ibrd(ud, sBuff)                            'GET POW data
    dRslt = Val(sBuff)
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "PMEASAVGOFF")                   'POW AVG OFF
    
    'ʕ\
    txtRslt.SelText = "ChPower = " & Format(dRslt, "###0.00") & "dBm" & vbCrLf

    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 

End Sub

Private Sub Command1_Click(Index As Integer)
Select Case Index
Case 0      'OBW
    MeasObw MFREQ, OBW_REF              'OBW

Case 1      'ACP
    MeasAcp MFREQ, ACP_REF              'ACP

Case 2      'SEM
    MeasSEM MFREQ, SEM_REF              'SEM

Case Else   'CH POW
    MeasChPow MFREQ, POW_REF            'ChPow

End Select

End Sub

Private Sub Command2_Click()
                                        'WLAN 11a SEM
Dim dRslt() As String
Dim measF As Double
Dim measRef As Double
Dim buf As String * 200
Dim i As Integer
Dim Mkbuf As String * 50
Dim PwrRef, lim1a, lim2a, lim3a As Double

measF = 5005000000#                     'Set Meas Frequency
measRef = 0                             'Set Ref Level

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "SEM Measurement..." & vbCrLf
    
    ' 1. Parameter setting
    ibwrt ud, "SI"
    ibwrt ud, "CF " & Format(measF) & "HZ"    'Center frequency
    ibwrt ud, "SP 80MZ"
    '   ibwrt ud, "RO 20DB; RO ON"                 'Level Offset
    ibwrt ud, "RL " & Format(measRef) & "DB"  'Reference level
    '
    ibwrt ud, "RB 100KZ; VB 30KZ; SW 500MS"
    ibwrt ud, "DET POS"
    
    ibwrt ud, "TS"
    ibwrt ud, "PS"
    ibwrt ud, "ML?"
    Mkbuf = ""
    ibrd ud, Mkbuf                              ' Reference Power = Peak
    PwrRef = Mkbuf + 2#                         ' 2 = ADJ ********** check...
    lim1a = -20# + PwrRef                       ' LIMIT Line + Reference Power + Adj
    lim2a = -28# + PwrRef
    lim3a = -40# + PwrRef
    
    ' Set Mask(WLAN 11a)
    ibwrt ud, "SEMTDEL"
    ibwrt ud, "SEMTIN  0MZ,  9MZ, 100KZ," & Format(PwrRef) & "DB," & Format(PwrRef) & "DB," & "0DB, 0DB, ABS"
    ibwrt ud, "SEMTIN  9MZ, 11MZ, 100KZ," & Format(PwrRef) & "DB," & Format(lim1a) & "DB," & "0DB, 0DB, ABS"
    ibwrt ud, "SEMTIN 11MZ, 20MZ, 100KZ," & Format(lim1a) & "DB," & Format(lim2a) & "DB," & "0DB, 0DB, ABS"
    ibwrt ud, "SEMTIN 20MZ, 30MZ, 100KZ," & Format(lim2a) & "DB," & Format(lim3a) & "DB," & "0DB, 0DB, ABS"
    ibwrt ud, "SEMTIN 30MZ, 39MZ, 100KZ," & Format(lim3a) & "DB," & Format(lim3a) & "DB," & "0DB, 0DB, ABS"
               
    '
    ibwrt ud, "SEMCBW 16.6MZ"                   ' Dummy -> Using Peak...
    ibwrt ud, "SEMRFCALC PEAK"                  ' Power = CH_Power or Peak_Power (miss-pri :V1.2)
    ibwrt ud, "SEMNQST OFF"
    ibwrt ud, "PMEASAVG OFF"

    ' Measure SEM

    ibwrt ud, "SEMON"
    ibwrt ud, "TS"    ' Take sweep
    ibwrt ud, "SEM?"
    
    txtRslt.SelText = " START F      STOP F       FREQ.      ABS LEV   REL LEV" & vbCrLf
    For i = 0 To 9
        buf = ""
        ibrd ud, buf
        dRslt = Split(buf, ",")
        txtRslt.SelText = Format(dRslt(1) / 1000000#, "#0.00") & "MHz---" & Format(dRslt(2) / 1000000#, "#0.00") & "MHz, " _
        & Format(dRslt(3) / 1000000#, "#0.00") & "MHz, " & Format(dRslt(4), "#0.00") & "dBm, " & Format(dRslt(5), "#0.00") & "dB," _
        & "  P/F = " & Format(dRslt(6)) & vbCrLf
    Next i
    Call ibwrt(ud, "SEMON OFF")
    Call ibwrt(ud, "CONTS")             'Sweep continue
    '  Call ibwrt(ud, "RO OFF")         'Offset level Off
    
    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 
                                        

End Sub

Private Sub Command3_Click()
                                        'WLAN 11b SEM
Dim dRslt() As String
Dim measF As Double
Dim measRef As Double
Dim buf As String * 200
Dim i As Integer
Dim Mkbuf As String * 50
Dim PwrRef, lim1a, lim2a As Double


measF = 2412000000#                     'Set Meas Frequency
measRef = 0                             'Set Ref Level

    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "SEM Measurement..." & vbCrLf
    
    ' 1. Parameter setting
    ibwrt ud, "SI"
    ibwrt ud, "CF " & Format(measF) & "HZ"    'Center frequency
    ibwrt ud, "SP 80MZ"
    '   ibwrt ud, "RO 20DB; RO ON"                 'Level Offset
    ibwrt ud, "RL " & Format(measRef) & "DB"  'Reference level
    '
    ibwrt ud, "RB 100KZ; VB 100KZ; SW 1SC"
    ibwrt ud, "DET POS"
    
    ibwrt ud, "TS"
    ibwrt ud, "PS"
    ibwrt ud, "ML?"
    Mkbuf = ""
    ibrd ud, Mkbuf                              ' Reference Power = Peak
    PwrRef = Mkbuf + 2#                         ' 2 = ADJ ********** check...
    lim1a = -30# + PwrRef                       ' LIMIT Line + Reference Power + Adj
    lim2a = -50# + PwrRef
    
    ' Set Mask(WLAN 11b)
    ibwrt ud, "SEMTDEL"
    ibwrt ud, "SEMTIN  0MZ, 11MZ, 100KZ," & Format(PwrRef) & "DB," & Format(PwrRef) & "DB," & "0DB, 0DB, ABS"
    ibwrt ud, "SEMTIN 11MZ, 22MZ, 100KZ," & Format(lim1a) & "DB," & Format(lim1a) & "DB," & "0DB, 0DB, ABS"
    ibwrt ud, "SEMTIN 22MZ, 39MZ, 100KZ," & Format(lim2a) & "DB," & Format(lim2a) & "DB," & "0DB, 0DB, ABS"
    
    ibwrt ud, "SEMCBW 16.6MZ"                   ' Dummy -> Using Peak...
    ibwrt ud, "SEMRPFCALC PEAK"                 ' Power = CH_Power or Peak_Power (miss-pri :V1.2)
    ibwrt ud, "SEMNQST OFF"
    ibwrt ud, "PMEASAVG OFF"
    
    ' Measure SEM

    ibwrt ud, "SEMON"
    ibwrt ud, "TS"    ' Take sweep
    ibwrt ud, "SEM?"

    txtRslt.SelText = " START F      STOP F       FREQ.      ABS LEV   REL LEV" & vbCrLf
    For i = 0 To 5
        buf = ""
        ibrd ud, buf
        dRslt = Split(buf, ",")
        txtRslt.SelText = Format(dRslt(1) / 1000000#, "#0.00") & "MHz---" & Format(dRslt(2) / 1000000#, "#0.00") & "MHz, " _
        & Format(dRslt(3) / 1000000#, "#0.00") & "MHz, " & Format(dRslt(4), "#0.00") & "dBm, " & Format(dRslt(5), "#0.00") & "dB," _
        & "  P/F = " & Format(dRslt(6)) & vbCrLf
    Next i
    Call ibwrt(ud, "SEMON OFF")
    Call ibwrt(ud, "CONTS")             'Sweep continue
    '  Call ibwrt(ud, "RO OFF")         'Offset level Off
    
    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 



End Sub

Private Sub Command4_Click()
                                        ' WLAN 11b Total Power
Dim sBuff As String * 50
Dim dRslt As String
Dim measF As Double
Dim measRef As Double

measF = 2412000000#                     'Set Meas Frequency
measRef = 0                             'Set Ref Level


    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "CH Power Measurement..." & vbCrLf

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "SP 40MZ")                       'Span 40MHz
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, "RB 300KZ; VB 300KZ")            'RBW 300kHz, VBW 300kHz
    Call ibwrt(ud, "SW 1SC")                        'Sweep Time 1sec
    Call ibwrt(ud, "DETAA ON")                      'DET Auto
    
'    Call ibwrt(ud, "WLX " & Format(measF) & "HZ")    'Ch Center
'    Call ibwrt(ud, "WDX " & Format(3840000#) & "HZ") 'Ch Span
'    Call ibwrt(ud, "PWCHON")                         'Ch Pow ON

    Call ibwrt(ud, "PWTOTALON")                       'TOT Pow ON
    
    If 1 Then                                   'AverageȂꍇ (1)
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                        'Averageꍇ   (0)
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWTOTALTM 5")                   'AVG 5 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait AVG end
    End If
    
    Call ibwrt(ud, "PWTOTAL?")                      'GET POW data
    Call ibrd(ud, sBuff)                            'GET POW data
    dRslt = Val(sBuff)
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "PMEASAVGOFF")                   'POW AVG OFF
    Call ibwrt(ud, "CONTS")                         'Sweep continue
    
    'ʕ\
    txtRslt.SelText = "ChPower = " & Format(dRslt, "###0.00") & "dBm" & vbCrLf

    Call ibonl(ud, 0)                   'GPIB device 
    Call ibonl(0, 0)                    'GPIB board 
                                                                                
                                        
End Sub

Private Sub Form_Load()

    txtRslt.Text = ""
    

End Sub
